# Human Retina Model User Guide

This file will provide the documentation on how to run the model, where the input files are, where the output files are, and how to view model outputs. Below are all the folders within the supplied precompiled code:

## General Information
This model has been developed in Visual Studio Code to run within the NEURON 7.1/7.2 simulation environment. General runtime for each model is approximately 17 hours for a 2 second simulation time. 

Within the folder you will find multiple conditions setup in the same model:

* Chirp Amplitude Model – 8 second simulation with increasing amplitudes every 0.5 secs. Photocurrent amplitude increases from 4 pA to 28 pA. Model is placed at 1.2 mm temporal eccentricity with a 100 ×100 µm patch.
* Chirp Frequency Model – 8 second simulation with increasing frequency of stimulation. Constant 40 pA amplitude increasing from 0.5 to 8 Hz stimulation. Model is placed at 1.2 mm temporal eccentricity with a 100 ×100 µm patch.
* Degenerate Central Retina - Degenerate peripheral model which reproduces oscillations in RGC membrane potential. Model is placed at 1.2 mm temporal eccentricity with a 100 ×100 µm patch.
 
* Epiretinal – 2 second simulation with electrode placed in the centre of the model, delivering stimulation at 1300 ms for a total duration of 400 ms. Currently setup for 40 µm diameter electrode placed at -75 µm z-position. Model is placed at 1.2 mm temporal eccentricity with a 100 ×100 µm patch.
* Full Field Light Stimulation – 2 second simulation with all photoreceptors stimulated with light at 1200 ms for a duration of 400 ms. Model is placed at 1.2 mm temporal eccentricity with a 100 ×100 µm patch.
* Intraretinal INL – 2 second simulation with electrode placed in the centre of the model, delivering stimulation at 1300 ms for a total duration of 400 ms. Currently setup for 5 µm diameter electrode placed at 75 µm z-position. Model is placed at 1.2 mm temporal eccentricity with a 100 ×100 µm patch.
* Intraretinal IPL – 2 second simulation with electrode placed in the centre of the model, delivering stimulation at 1300 ms for a total duration of 400 ms. Currently setup for 5 µm diameter electrode placed at -50 µm z-position. Model is placed at 1.2 mm temporal eccentricity with a 100 ×100 µm patch.
* Peripheral Retinal Model – Degenerate peripheral model which reproduces oscillations in RGC membrane potential. Model is placed at 3 mm temporal eccentricity with a 150 ×150 µm patch.
* Spotlight 40 um diameter model – 2 second stimulation with photoreceptors within 40 um circle in the centre stimulated with light at 1200 ms for a duration of 400 ms. Model is placed at 1.2 mm temporal eccentricity with a 100 ×100 µm patch.
* Subretinal - 2 second simulation with electrode placed in the centre of the model, delivering stimulation at 1300 ms for a total duration of 400 ms. Currently setup for 40 µm diameter electrode placed at 125 µm z-position. Model is placed at 1.2 mm temporal eccentricity with a 100 ×100 µm patch.

## To Run the Model
To run the model, run the `init_Full_Human_Network.hoc` file. This will automatically generate the session file which shows each individual cell as well as RGCs. A shape plot with the electrode is also shown and can be used to locate the electrode position. 


The console should output the total number of cell types:

### Model Workflow
The model is separated into 4 different segments, the physiological model (which constitutes building the individual neurons, connections and kinetics, the light stimulation model (which is used to change photoreceptor input and membrane potential), the electrical stimulation model (which is used to deliver extracellular electrical stimulation to the model), and files for outputting neuronal responses to .csv files.

**Bottom Level**

These files the building blocks of the model and are read into the cell templates and hoc files. These are in the mod folder in the model. If any of these files are modified, you will need to recompile using the mknrndll file and copy the generated nrnmech.dll and mod_func.c, and mod_func.o files into the main folder. 

AII Amacrine Cell (AII AC):

* `A2_ika_arm.mod` – file for defining the IKa channel in the AII AC’s arm compartment.
* `A2_ika_IS.mod` – file for defining the IKa channel in the AII AC’s initial segment compartment.
* `A2_ika_soma.mod` – file for defining the IKa channel in the AII AC’s soma compartment.
* `A2_ikm_arm.mod` – file for defining the IKm channel in the AII AC’s arm compartment.
* `A2_ ikm _IS.mod` – file for defining the IKm channel in the AII AC’s initial segment compartment.
* `A2_ ikm _soma.mod` – file for defining the IKm channel in the AII AC’s soma compartment.
* `A2_ina_arm.mod` – file for defining the INa channel in the AII AC’s arm compartment.
* `A2_ina _IS.mod` – file for defining the INa channel in the AII AC’s initial segment compartment.
* `A2_ina _soma.mod` – file for defining the INa channel in the AII AC’s soma compartment.

Bipolar Cell (BC):

* `Bip_Ca.mod` – file for defining the ICa and IKca channels in the BCs.
* `Bip_Cad.mod` – file for defining the Ca pump in the BC s.
* `Bip_ih.mod` – file for defining the Ih channel in the BCs.
* `Bip_Ka.mod` – file for defining the IKa channel in the BC s.
* `Bip_Kv.mod` – file for defining the IKv channel in the BCs.

Cone:

* `Cone_CPR.mod` – file for defining the ICa, ICl, and IKca channels in the cones.
* `Cone_ih.mod` – file for defining the Ih channel in the cones.
* `Cone_Kv.mod` – file for defining the IKv channel in the cones.

Horizontal Cell (HZ):

* `Horizontal_IA` – file for defining the IA channel in the HZs.
* `Horizontal_ICa` – file for defining the ICa channel in the HZs.
* `Horizontal_IKa` – file for defining the IKa channel in the HZs.
* `Horizontal_IKv` – file for defining the IKv channel in the HZs.
* `Horizontal_IL` – file for defining the IL channel in the HZs.
* `Horizontal_INa` – file for defining the INa channel in the HZs.

Ganglion Cell (RGC):

* `capump.mod` – file for defining the Ca pump in the RGCs.
* `icat.mod` – file for defining the ICaT channel in RGCs (currently unused).
* `ih.mod` – file for defining the Ih channel in RGCs (currently unused).
* `inap.mod` – file for defining the INaP channel in RGCs (currently unused).
* `spike.mod` – file for defining Fohlmeister and Miller 5 channels for RGCs.
* `spikeOprm.mod` – file for defining optimized Fohlmeister and Miller 5 channels for RGCs (currently unused).
Light Stimulation:
* `IinjLT.mod` – file for creating a photocurrent defined as a nonspecific current for light stimulation of Rods.
* `IinjLT_cone.mod` – file for creating a photocurrent defined as a nonspecific current for light stimulation of Cones.
* `IinjLT_dim.mod` – file for creating a photocurrent defined as a nonspecific current for steady state stimulation of Rods.

Rod:

* `Rod_Ca.mod` – file for defining the ICa channel in Rods (currently unused).
* `Rod_CPR.mod` – file for defining the ICa, ICl, IKca channels in Rods.
* `Rod_hyper` – file for defining the Ih channel in Rods.
* `Rod_Kv` – file for defining the IKv channel in Rods.
* `Rod_Kx` – file for defining the IKx channel in Rods.
* `Rod_leak` – file for defining the IL channel in Rods.

Synapses:

* `syn_ama_bip_inhib.mod` – file for defining the point process which is used to create the inhibitory synapse between the AII AC and OFF BC.
* `syn_ama_gan_inhib.mod` – file for defining the point process which is used to create the inhibitory synapse between the AII AC and OFF RGC.
* `syn_bip_ama_excite.mod` – file for defining the point process which is used to create the excitatory synapse between the RBC and AII AC.
* `syn_bip_gan_excite.mod` – file for defining the point process which is used to create the excitatory synapse between the BC and RGC.
* `syn_horizon_PR.mod` – file for defining the point process which is used to create the synapse between the PR and HZ.
* `syn_rod_bip_excite.mod` – file for defining the point process which is used to create the excitatory synapse between the PR and BC.
* `syn_rod_bip_inhib.mod` – file for defining the point process which is used to create the inhibitory synapse between the PR and BC.
* `Xtra.mod` – file for creating a mechanism to read and story xyz position of compartments.

To recompile, run the following file found in the NEURON folder and search in the directory for the mod folder. Compile and copy the generated nrnmech.dll files to the outside folder.

**Middle Level**

These files are the templates used to create multiple cells of the same types. In addition, this is also used to create gap junctions between cells.

Cell Templates:

* `A2.tem` – template file for defining cell morphology, topology, and biophysics for the AII AC.
* `Bip.tem` – template file for defining cell morphology, topology, and biophysics for the BC.
* `Cone.tem` – template file for defining cell morphology, topology, and biophysics for the Cone.
* `Horizontal.tem` – template file for defining cell morphology, topology, and biophysics for the Horizontal.

For individual RGCs, these are stored in the `cellHoc` folder and are generated from Italiano 2022. 

Network Connection Templates:

* `AII_ONBCgap.tem` – template file which uses a linear mechanism with a nonsymmetric conductance. Used to define the gap junction between AII AC and ON BC.
* `gap.tem` – template file which uses a linear mechanism with a symmetric conductance. Used to define the connection between PRs.

**Top Level**

At this level, all the code generated are individual executable files. A flowchart is shown below of the individual files and how they are linked. There are 4 sections to the code: 1) the physiological model which includes the neurons and cells, 2) the electrical stimulation model, which is used to model different extracellular stimulation strategies, 3) light stimulation used to validate the model, and 4) saving responses and properties of cells.

### Parameters (stored in `Parameters.hoc`):

Simulation:

* Time_Step – integration time step.
* Simul_Time – total simulation time.
* sample_time – sampling time for saving responses.

Retinal Degeneration

* PR_loss – amount of photoreceptor loss (from 0 to 1).
* RD_Late_Active – amount of amacrine cell synapse remaining (from 1 to 0).
* BC_Syn_loss – amount of BC synaptic loss (from 0 to 1)

Localisation

* radius_lim – limits of the model (should not be larger than the macular, defined by computational power).
* Patch_size_x – length of the patch.
* Patch_size_y – width of the patch.
* Eccentricity_x – x position of the centre of the model.
* Eccentricity_y – y position of the centre of the model.
* Fovea_x – Relative x position of the fovea.
* Fovea_y– Relative y position of the fovea.

Retinal thickness – currently using healthy values.

* NFL_thickness – nerve fibre layer thickness.
* IPL_GCL_Thickness – inner plexiform layer + ganglion cell layer thickness
* INL_Thickness – inner nuclear layer thickness
* OPL_Thickness – outer plexiform layer thickness
* ONL_PIS_Thickness – outer nuclear layer + photoreceptor inner segment thickness.
* POS_Thickness – photoreceptor outer segment thickness
* Retinal_total_thickness – total retinal thickness

Randomisation seed

* seed – used to define the randomisation of the cell arrays and connections.

Connectivity

* MaxNumRod2BC – maximum number of rods to BCs, used to scale synaptic conductances.
* MaxNumCone2ONBC – maximum number of cones to ON BCs, used to scale synaptic conductances.
* MaxNumCone2OFFBC – maximum number of cones to OFF BCs, used to scale synaptic conductances.
* MaxNumCone2HZ – maximum number of cones to HZs, used to scale synaptic conductances.
* MaxNumRBC2AII – maximum number of RBCs to AII ACs, used to scale synaptic conductances.
* MaxNumONBC2AII – maximum number of ON BCs to AII ACs, used to scale gap junction conductances.
* MaxNumAII2OFFBC – maximum number of AII ACs to OFF BCs, used to scale synaptic conductances.
* MaxNumAII2OFFRGC – maximum number of AII ACs to OFF RGCs, used to scale synaptic conductances.
* MaxNumBC2RGC – maximum number of BCs to RGCs, used to scale synaptic conductances.

RGC buffers

* RGC_dend_buffer – extra reach of dendrites of RGCs to account for diffusion of synaptic vesicles
* RGC_dend_ratio – randomisation parameter to reduce the number of synpases and randomise the connection (currently not used, inactivated in the create_connections.hoc file).

Conductance values

* HomoPRGap – homocellular gap junction conductance of PRs (rod to rod, cone to cone).
* HeteroPRGap – heterocellular gap junction conductance of PRs (rod to cone).
* Ama2BipGap - heterocellular gap junction conductance of AII ACs to ON BCs
* HorizontalEXSynapticConductance – excitatory conductance of cones to HZs.
* HorizontalINSynapticConductance – inhibitory conductance of HZs to cones.
* ONBipSynapticConductance – Conductance of cones to ON BCs.
* OFFBipSynapticConductance – Conductance of cones to OFF BCs.
* RodBipSynapticConductance - Conductance of rods to RBCs.
* AmaSynapticConductance – Conductance of AII ACs to OFF BCs.
* Ama2GanSynapticConductance - Conductance of AII ACs to OFF RGCs.
* RodBip2AmaSynapticConductance – Conductance of RBCs to AII ACs.
* GanSynapticConductance – Conductance of BCs to RGCs.

Threshold values – synapses are activated once the membrane potential of the presynaptic cells crosses the thresholds.

* HorizontalEXSynapticThreshold – Threshold of excitatory synapses of HZs with presynaptic membrane potential of cones.
* HorizontalINSynapticThreshold – Threshold of inhibitory synapses of cones with presynaptic membrane potential of HZs.
* RodBipSynapticThreshold – Threshold of excitatory synapses of RBCs with presynaptic membrane potential of Rods.
* ConeBipSynapticThreshold – Threshold of excitatory synapses of ON BCs and inhibitory synapses of OFF BCs with presynaptic membrane potential of Cones.
* AmaSynapticThreshold – Threshold of inhibitory synapses of OFF RGCs with presynaptic membrane potential of AII ACs.
* Ama2ConeOFFBipThreshold – Threshold of inhibitory synapses of OFF BCs with presynaptic membrane potential of AII ACs. 
* RodBip2AmaSynapticThreshold – Threshold of excitatory synapses of AII ACs with presynaptic membrane potential of RBCs.
* ConeONGanSynapticThreshold – Threshold of excitatory synapses of ON RGCs with presynaptic membrane potential of ON BCs.
* ConeOFFGanSynapticThreshold – Threshold of excitatory synapses of OFF RGCs with presynaptic membrane potential of OFF BCs.

Light Stimulation

* RodStimAmp – stimulus amplitude of the photocurrent in rods.
* RodStimDel – stimulus delay of the photocurrent in rods.
* RodStimTime – total stimulation time of photocurrent in rods.
* ConeStimAmp – stimulus amplitude of the photocurrent in cones.
* ConeStimDel – stimulus delay of the photocurrent in cones.
* ConeStimTime – total stimulation time of photocurrent in cones.

### Physiological Model:


`Network_distributions.hoc` - This file contains values which are used to calculate eccentricity specific cell densities of presynaptic cells.

`Cell_positions.hoc` - This file generates matrices filled with positions of each cell type. 

Procedure - `calc_cell_density()`

* Calculates the cell density (in cells/mm2) based on input arguments.
* Input arguments are (x, y, z, cell type)

Procedure – `calc_cell_spacing()`

* Calculates the x and y spacing between cells using the cell_density_value output from the calc_cell_density() procedure.

Procedure - `determine_cell_init_positions()`

* Generates a matrix with position of cells which go from bottom left of population towards top right of the population.
* Creates a separate matrix for PRs, HZs, BCs, and ACs.

Procedure - `generate_population_positions()`

* Creates 2 matrices with positions from upper half of the population and lower half of the population.

Function - `calc_PR_density()`

* Calculates the probability of a PR being either a cone or rod based on the density values of both cells. 
* Outputs a type value used in `create_cells.hoc` to determine the cell type.

Function - `calc_BIP_density()`

* Calculates the probability of a BC being either a RBC, ON BC, or OFF BC using the density values of all 3 types.

`mod_RGC_population.txt` - Text file which contains information of the RGC population, created from Italiano 2022. Contains:
* cell index
* type – 1 = ON, 2 = OFF
* soma x position
* soma y position
* soma z position
* dendritic diameter
* dendritic area
* dendrite tree x position
* dendrite tree y position
* dendrite tree z position

`read_population.hoc` - This file reads the properties in mod_RGC_population.txt and generates all RGC templates contained in the cellHoc folder.

Procedure - `read_write_RGC_population()`

* Reads the `mod_RGC_population.txt` and scans the file into the RGC_param matrix.

Procedure - `split_RGC_parameters()`

* Splits the parameters stored in the RGC_param matrix into soma and dendritic positions.
* Also reads the cell types and dendritic radius.

Procedure - `load_RGC_templates()`

* Dynamically loads each individual RGC file from the cellHoc folder.

Procedure - `generate_RGC_cells()`

* Generates each individual RGC template into an object reference and saves the properties of each RGC into the corresponding matrices for use later.

Procedure - `calc_dendrite_centre()`

* Calculates the centres of each dendritic compartment of each RGC object.
* Used to determine synaptic connections.

Procedure - `change_RGC_ionic_properties()`
* Used to change the biophysics of each RGC compartment outside of NMODL so the compiler does not need to be used.

`create_Cells.hoc` - This file loads in each cell template as well as the read_population.hoc file which generates the RGC layer. This file uses the cell positions calculated in `Cell_positions.hoc` and generates every cell in each array.

Procedure - `generate_PR_array()`

* Generates the PR array based on cell positions and type values.

Procedure - `generate_HZ_array()`
* Generates the HZ array based on cell positions.

Procedure - `generate_BIP_array()`

* Generates the BC array based on cell positions and type values.

Procedure - `generate_AII_array()`

* Generates the AC array based on cell positions.

Procedure - `generate_RGC_array()`

* Generates the RGC array by calling the procedures within `read_population.hoc`

Procedure - `print_total_cells()`
* Prints out the total cells generated by the model into the console.

`create_Connections.hoc` - This file creates the synaptic and gap junction connections between cells in each array. Generally, the spacing between cells at each position is used to determine the receptive field of each cell unless the dendritic diameter is provided (used for RGCs).
* This file calls upon the procedures defined in `create_Cells.hoc` to generate all the cells for connections.

Procedure - `generate_PR_Gap_Junctions()`

* Creates the homocellular and heterocellular gap junction connections between PRs. Each cell was given an index based on how close it is to the diagonal and only cells next to each other is connected by the gap junction.

Procedure - `generate_AII_gap_junctions()`

* Creates the homocellular gap junction connections between neighbouring AII ACs.

Procedure - `generate_dendritic_fields()`

* Calculates the dendritic fields of each cell in each array and stores it into a matrix. Used to determine connectivity be identifying if presynaptic cells fall within each dendritic field.

Procedure - `generate_PR2BC_Synapses()`

* Generates the synaptic connections between PRs and BCs. Only cells of the same type (rods->RBCs, cones->ON BCs, cones->OFF BCs) have connections.
* Distance from centre of BC soma compartment and PR soma compartment used to determine the distance between cells.

Procedure - `generate_BC2RGC_Synapse()`

* Generates the synaptic connections between BCs and RGCs. Only cells with the same type have connections generated (ON BCs->ONRGCs, OFF BC->OFF RGCs).
* Distance from centre of each individual dendritic compartment of RGCs and BC soma used to determine the distance between cells. Multiple connections to different dendrites can be created.

Procedure - `generate_HZ_Synapses()`

* Generates the connections between cones and HZs.

Procedure - `generate_AII_Synapses()`

* Generates the inhibitory glycinergic synapses between AII AC, OFF BC, and OFF RGCs.
* Generates the gap junction connection of AII ACs to ON BCs.
* Generates the excitatory connection of RBCs to AII ACs.

Procedure - `create_Clamps()`
* Creates vClamps of every single cell to initialise the model and remove initial unsteady conditions.

### Electrical Stimulation:

`stimHexMono_biphasic.hoc`1 - This file implements both hexagonal and monopolar stimulation electrodes. Currently only monopolar stimulation is utilised.
* hexElecRad – electrode radius in um.
* hexX – x position of electrode.
* hexY – y position of electrode.
* hexZ – z position of electrode. Epiretinal = -75, IPL = 50, INL = 75, subretinal = 200.
* stim_freq – frequency of stimulus in Hz.
* hexDel – delay of stimulation. Usually until unstable initial conditions have passed.
* hexDur – duration of a single phase of stimulation.
* hexAmp – amplitude of stimulation.
* instr.hoc 
* This file is for inserting extracellular and xtra mechanisms into each cell. 
* Isolating cell response to extracellular stimulation can be created by commenting out the cells in the iExtraStim procedure.
Saving Outputs:

`save_Matrices.hoc`

* This file saves properties of each individual cell into a csv file placed in the matrices folder.

`save_responses.hoc`

* This file saves each individual cell’s membrane potential into the cell_reponses folder.

